﻿//////////////////////////////////////////////
// FileExplorer.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkWinUi
{
	class System ;
}

/// Includes ---------------------------------

// nkWinUi
#include "Component.h"
	
#include "../Dll/DllDefines.h"

// nkMemory
#include <NilkinsMemory/Containers/String.h>

#include <NilkinsMemory/Pointers/UniquePtr.h>

// Standards
#include <vector>

/// Class ------------------------------------
		
namespace nkWinUi
{
	class DLL_WINUI_EXPORT FileExplorer : public Component
	{
		public :

			struct FileFilter
			{
				nkMemory::String _label ;
				nkMemory::String _extension ;
			} ;
		
		public :
		
			// Constructeur, destructeur
			FileExplorer (System* system) noexcept ;
			virtual ~FileExplorer () ;

			// Filters
			void addFilter (nkMemory::StringView label, nkMemory::StringView extension) ;
			FileFilter& getFilter (unsigned int index) ;
			void setFilter (unsigned int index, nkMemory::StringView label, nkMemory::StringView extension) ;

			// Folder follow up
			void setFollowSelfDir (bool value) ;
			bool getFollowSelfDir () const ;
			void setCurrentDir (nkMemory::StringView path) ;
			nkMemory::StringView getCurrentDir () const ;

			// Load / Save
			virtual nkMemory::String openDialog (bool forSave) = 0 ;

			// Import / Export
			virtual void exportIntrospection (nkExport::Node* rootNode) override ;
			virtual void importClassFromTree (nkExport::Node* rootNode) override ;

		public :

			// Statics
			static nkMemory::UniquePtr<FileExplorer> create (System* system = nullptr) ;

		protected :
		
			// Attributes
			std::vector<FileFilter> _filters ;

			nkMemory::String _currentDir ;
			bool _followSelfDir ;
	} ;
}